/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.descriptions.IColonyEventDescription;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventDescriptionTypeRegistryEntry;
import com.minecolonies.api.colony.managers.interfaces.IEventDescriptionManager;
import com.minecolonies.api.util.Log;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class EventDescriptionManager
implements IEventDescriptionManager {
    private static final String TAG_EVENT_DESC_LIST = "event_descs_list";
    private final IColony colony;
    private final LinkedList<IColonyEventDescription> eventDescs = new LinkedList();

    public EventDescriptionManager(IColony colony) {
        this.colony = colony;
    }

    @Override
    public void addEventDescription(IColonyEventDescription colonyEventDescription) {
        if (this.eventDescs.size() >= 100) {
            this.eventDescs.removeFirst();
        }
        this.eventDescs.add(colonyEventDescription);
        if (this.colony.getBuildingManager().getTownHall() != null) {
            this.colony.getBuildingManager().getTownHall().markDirty();
        } else {
            this.colony.markDirty();
        }
    }

    @Override
    public List<IColonyEventDescription> getEventDescriptions() {
        return this.eventDescs;
    }

    public void deserializeNBT(@NotNull CompoundNBT eventManagerNBT) {
        ListNBT eventDescListNBT = eventManagerNBT.func_150295_c(TAG_EVENT_DESC_LIST, 10);
        for (INBT event : eventDescListNBT) {
            CompoundNBT eventCompound = (CompoundNBT)event;
            ResourceLocation eventTypeID = new ResourceLocation("minecolonies", eventCompound.func_74779_i("name"));
            ColonyEventDescriptionTypeRegistryEntry registryEntry = (ColonyEventDescriptionTypeRegistryEntry)MinecoloniesAPIProxy.getInstance().getColonyEventDescriptionRegistry().getValue(eventTypeID);
            if (registryEntry == null) {
                Log.getLogger().warn("Event is missing registryEntry!:" + eventTypeID.func_110623_a());
                continue;
            }
            IColonyEventDescription eventDescription = registryEntry.deserializeEventDescriptionFromNBT(eventCompound);
            this.eventDescs.add(eventDescription);
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT eventManagerNBT = new CompoundNBT();
        ListNBT eventDescsListNBT = new ListNBT();
        for (IColonyEventDescription event : this.eventDescs) {
            CompoundNBT eventNBT = (CompoundNBT)event.serializeNBT();
            eventNBT.func_74778_a("name", event.getEventTypeId().func_110623_a());
            eventDescsListNBT.add((Object)eventNBT);
        }
        eventManagerNBT.func_218657_a(TAG_EVENT_DESC_LIST, (INBT)eventDescsListNBT);
        return eventManagerNBT;
    }
}

